/* ==========================================================
   PDF Pro — Configuration File
   Toggle APIs and settings without touching application code
   ========================================================== */

const CONFIG = {

  /* ── Site ── */
  site: {
    name: 'PDF Pro',
    tagline: 'Free Online PDF Tools',
    url: 'https://yourdomain.com',
    email: 'support@yourdomain.com',
    maxFileSizeMB: 500,
    maxFileSizeBytes: 500 * 1024 * 1024,
  },

  /* ── Translation APIs (priority order) ── */
  /* Set enabled:true and add your API key to activate */
  translationAPIs: [
    {
      id: 'google',
      name: 'Google Translate',
      enabled: false,
      key: '',
      endpoint: 'https://translation.googleapis.com/language/translate/v2',
      priority: 1,
    },
    {
      id: 'deepl',
      name: 'DeepL',
      enabled: false,
      key: '',
      endpoint: 'https://api-free.deepl.com/v2/translate',
      priority: 2,
    },
    {
      id: 'azure',
      name: 'Azure Translator',
      enabled: false,
      key: '',
      region: 'eastus',
      endpoint: 'https://api.cognitive.microsofttranslator.com/translate',
      priority: 3,
    },
    {
      id: 'aws',
      name: 'AWS Translate',
      enabled: false,
      accessKey: '',
      secretKey: '',
      region: 'us-east-1',
      priority: 4,
    },
    {
      id: 'ibm',
      name: 'IBM Watson Language Translator',
      enabled: false,
      key: '',
      url: '',
      priority: 5,
    },
    {
      id: 'yandex',
      name: 'Yandex Translate',
      enabled: false,
      key: '',
      endpoint: 'https://translate.api.cloud.yandex.net/translate/v2/translate',
      priority: 6,
    },
    {
      id: 'mymemory',
      name: 'MyMemory',
      enabled: true,     // Free, no key needed
      key: '',
      endpoint: 'https://api.mymemory.translated.net/get',
      priority: 7,
    },
    {
      id: 'lingva',
      name: 'Lingva Translate',
      enabled: true,     // Free, no key needed
      key: '',
      endpoint: 'https://lingva.ml/api/v1',
      priority: 8,
    },
    {
      id: 'libre',
      name: 'LibreTranslate',
      enabled: true,
      key: '',
      endpoint: 'https://libretranslate.com/translate',
      priority: 9,
    },
    {
      id: 'argos',
      name: 'Argos Translate (LibreTranslate mirror)',
      enabled: true,
      key: '',
      endpoint: 'https://translate.argosopentech.com/translate',
      priority: 10,
    },
    {
      id: 'microsoft_free',
      name: 'Microsoft Translator (free tier)',
      enabled: false,
      key: '',
      endpoint: 'https://api.cognitive.microsofttranslator.com',
      priority: 11,
    },
    {
      id: 'papago',
      name: 'Naver Papago',
      enabled: false,
      clientId: '',
      clientSecret: '',
      priority: 12,
    },
    {
      id: 'modernmt',
      name: 'ModernMT',
      enabled: false,
      key: '',
      endpoint: 'https://api.modernmt.com/translate',
      priority: 13,
    },
    {
      id: 'systran',
      name: 'SYSTRAN',
      enabled: false,
      key: '',
      endpoint: 'https://api-platform.systran.net/translation/text/translate',
      priority: 14,
    },
    {
      id: 'glosbe',
      name: 'Glosbe',
      enabled: false,
      key: '',
      priority: 15,
    },
    {
      id: 'lecto',
      name: 'Lecto AI',
      enabled: false,
      key: '',
      endpoint: 'https://api.lecto.ai/v1/translate/text',
      priority: 16,
    },
    {
      id: 'oneringtranslation',
      name: 'One Ring Translation',
      enabled: false,
      key: '',
      priority: 17,
    },
    {
      id: 'translatecom',
      name: 'Translate.com',
      enabled: false,
      key: '',
      priority: 18,
    },
    {
      id: 'rapidapi_google',
      name: 'RapidAPI Google Translate',
      enabled: false,
      key: '',
      host: 'google-translate1.p.rapidapi.com',
      priority: 19,
    },
    {
      id: 'chatgpt',
      name: 'ChatGPT (OpenAI)',
      enabled: false,
      key: '',
      model: 'gpt-3.5-turbo',
      endpoint: 'https://api.openai.com/v1/chat/completions',
      priority: 20,
    },
  ],

  /* ── Optional PHP proxy for CORS-blocked APIs ── */
  proxy: {
    enabled: false,
    url: '/api/proxy.php',
  },

  /* ── Offline fallback ── */
  offlineFallback: {
    enabled: true,
    showDisclaimer: true,
    chunkSize: 200,   // chars per chunk
  },

  /* ── PDF Processing ── */
  pdf: {
    defaultCompressQuality: 0.7,
    defaultImageDPI: 150,
    defaultJpgQuality: 0.9,
    workerSrc: 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js',
  },
};

/* Freeze to prevent accidental mutation */
Object.freeze(CONFIG);
